package entities;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name = "Addr")
public class Address {

	@Id
	private long id;

	private String street;
	private String city;

	 @OneToOne(cascade=CascadeType.ALL, mappedBy="address")
	 private Employee employee;

	@Column(name = "St", length = 2)
	private String state;

	public Address(long id, String street, String city, String state) {
		this.id = id;
		this.street = street;
		this.city = city;
		this.state = state;
	}

	public Address() {
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getStreet() {
		return street;
	}

	public void setStreet(String street) {
		this.street = street;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String toString() {
		return "street: " + street + ", city: " + city + ", state: " + state;
	}

	public Employee getEmployee() {
		return employee;
	}

	public void setEmployee(Employee employee) {
		this.employee = employee;
	}

}
